TITLE   'Force on Wire and Magnetic Cylinder'			{ exa124.pde }
SELECT     					{ Professional Version }
   errlim=1e-4     ngrid=1     spectral_colors	
VARIABLES   Az                   		
DEFINITIONS                      			
   mu0=4*pi*1e-7    mu     Jz0=1.0     Jz	{ Jz in wire }		
   r0=1e-3     rc=2.5e-3    y0=2e-3    r1=1.0
   Bex=dy(Az)     Bey=-dx(Az)
   B=vector( Bex, Bey)     Bm=magnitude( B)
   Hx=Bex/mu     Hy=Bey/mu     H=B/mu     Hm=Bm/mu	
   F_wire=area_integral( Jz*Bex, 'wire') 	{ Lorentz force }
   fs=0.5*(mu-mu0)*[ tangential(H)^2+ mu/mu0*normal(H)^2]	
   unit_y=vector(0,1)		                 	{ Unit vector along y }
   f=fs*normal( unit_y)	                           	{ y-component }
   F_magnet=line_integral( f, 'circle', 'magnet')	
EQUATIONS
   dx( Hy)- dy( Hx)=Jz
BOUNDARIES
region 'domain'  Jz=0  mu=mu0  start 'outer' (-r1,0) value(Az)=0
   arc(center=0,0) angle=360
region 'wire'  Jz=Jz0  mu=mu0  start (r0,-y0)  	{ Densify mesh }
   mesh_spacing=0.2*r0 arc( center=0,-y0) angle=360
region 'magnet' Jz=0  mu=1e3*mu0  start 'circle' (rc,y0)
   mesh_spacing=0.2*r0  arc( center=0,y0) angle=360
PLOTS
   contour( Bm) painted zoom(-4*y0,-4*y0,  8*y0,8*y0)
      report(F_wire)   report(F_magnet) 	
   contour( Bm) painted zoom(-4*y0,-4*y0,  8*y0,8*y0)
      fixed range(0, 3e-10)
END

